/*
 *  Envlink File System, version 0.2, 27.04.1998
 *
 *  envlinkfs/inode.c
 *
 *  Copyright (C) 1998 by Stelian Pop <pop@cybercable.fr>
 *
 */

#include <linux/config.h>
#include <linux/version.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/malloc.h>
#include <asm/segment.h>

#include "envlinkfs.h"

extern int envlinkfs_getenv_if(char *, char *, int, int);
extern int envlinkfs_envexists_if(char *, int);
extern struct envlinkfs_dir_entry *de;

/*
 * Returns the name of the link.
 */
static int 
envlinkfs_inode_readlink(struct inode *inode, char *buffer, int buflen)
{
	int len;
	char *name;
	struct envlinkfs_dir_entry *entry;

	PRINTK("envlinkfs: envlinkfs_inode_readlink\n");
	if (!inode)
		return -ENOENT;

	entry = de;
	while (entry) {
		if (entry -> ino == inode -> i_ino)
			break;
		entry = entry -> next;
	}
	iput(inode);
	if (!entry)
		return -ENOENT;

	name = kmalloc(4096, GFP_KERNEL);
        if ((envlinkfs_getenv_if(entry->dest, name, 4096, entry->dest_is_env) == -1)
		|| (envlinkfs_envexists_if(entry->name, entry->name_is_env) == -1)) {
		kfree(name);
		return -ENOENT;
	}
	
	if (strlen(name) < buflen)
		len = strlen(name);
	else
		len = buflen;
	memcpy_tofs(buffer, name, len);
	kfree(name);
	return len;
}

/*
 * Returns the destination of the link.
 */
static int 
envlinkfs_inode_followlink(struct inode *dir, struct inode *inode, int flag, int mode, struct inode **res_inode) 
{
	int err;
	char *name;
	struct envlinkfs_dir_entry *entry;

	PRINTK("envlinkfs: envlinkfs_inode_followlink\n");
	*res_inode = NULL;
	if (!dir) {
		if (inode) iput(inode);
		return -EINVAL;
	}
	if (!inode) {
		iput(dir);
		return -ENOENT;
	}
	if (!S_ISLNK(inode->i_mode)) {
		iput(dir);
		*res_inode = inode;
		return 0;
	}

        entry = de;
        while (entry) {
                if (entry -> ino == inode -> i_ino)
                        break;
                entry = entry -> next;
        }
        if (!entry) {
		iput(dir);
                iput(inode);
                return -ENOENT;
        }

	name = kmalloc(4096, GFP_KERNEL);
        if ((envlinkfs_getenv_if(entry->dest, name, 4096,entry->dest_is_env) == -1) 
		|| (envlinkfs_envexists_if(entry->name, entry->name_is_env) == -1)) {
		iput(dir);
                iput(inode);
		kfree(name);
                return -ENOENT;
        }

	PRINTK("namei: %s %d %d\n", name, flag, mode);

	err = open_namei(name, flag, mode, res_inode, dir);
	iput(inode);
	kfree(name);
	return err;
}

/*
 * Inode operations: simple, we have only envlinks.
 */
struct inode_operations envlinkfs_inode_operations = {
        NULL,                   /* no */
        NULL,                   /* create */
        NULL,                   /* lookup */
        NULL,                   /* link */
        NULL,                   /* unlink */
        NULL,                   /* envlink */
        NULL,                   /* mkdir */
        NULL,                   /* rmdir */
        NULL,                   /* mknod */
        NULL,                   /* rename */
        envlinkfs_inode_readlink, /* readlink */
        envlinkfs_inode_followlink,/* follow_link */
        NULL,                   /* readpage */
        NULL,                   /* writepage */
        NULL,                   /* bmap */
        NULL,                   /* truncate */
        NULL                    /* permissions */
};

