/*
 * kissd - KiSS PC-Link Daemon
 *
 * Copyright (C) 2005 Stelian Pop <stelian@popies.net>
 *
 * Heavily based on kiss4lin,
 * Copyright (C) 2004 Jacob Kolding <dacobi@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <syslog.h>

extern int d_opt, k_opt, v_opt;

extern char audiopath[];
extern char videopath[];
extern char picturepath[];
extern char kmlurl[];

#define KISSD_VERSION "version 0.5, Apr 15, 2005"

void handle_request(int sock);
void handle_kmlrequest(int sock);
void clean_pathname(char *path);

#define log(format, args...)					\
	do {							\
		if (d_opt)					\
			syslog(LOG_WARNING, format, args);	\
		else						\
			fprintf(stderr, format "\n", args);	\
	} while(0)

#define max(a, b) (((a) > (b)) ? (a) : (b))
